// backend/controllers/roleController.js

const Role = require('../models/roleModel');

/**
 * @desc    Get all available roles in the system
 * @route   GET /api/roles
 * @access  Private (Super Admin, Admin)
 */
exports.getAllRoles = async (req, res) => {
  try {
    const roles = await Role.findAll();
    res.status(200).json(roles);
  } catch (error) {
    res.status(500).json({ message: 'Error fetching roles.', error: error.message });
  }
};