// controllers/superAdminController.js

const Institution = require('../models/institutionModel');
const Subscription = require('../models/subscriptionModel');
const Student = require('../models/studentModel');
const Attendance = require('../models/attendanceModel');

/**
 * @desc    Get platform-wide dashboard statistics
 * @route   GET /api/super-admin/dashboard/stats
 * @access  Private (Super Admin)
 */
exports.getPlatformStats = async (req, res) => {
  try {
    // Fetch all stats concurrently for performance
    const [
      activeInstitutions,
      activeSubscriptions,
      totalStudents,
      todaysLogins, // A hypothetical stat for platform activity
    ] = await Promise.all([
      Institution.countAllActive(),
      Subscription.countActive(),
      Student.countPlatformTotal(),
      Attendance.getTodaysUniqueCount(), // Re-use this model, but without an institution_id
    ]);

    res.status(200).json({
      activeInstitutions,
      activeSubscriptions,
      totalStudents,
      studentsAttendedToday: todaysLogins,
    });
  } catch (error) {
    res.status(500).json({ message: "Server error fetching platform stats.", error: error.message });
  }
};