// backend/models/roleModel.js
const db = require('../config/db');

const Role = {
  /**
   * Retrieves all available roles.
   * @returns {Promise<Array<object>>} An array of role objects.
   */
  findAll: async () => {
    const [rows] = await db.query('SELECT * FROM roles ORDER BY id ASC');
    return rows;
  },

  /**
   * Finds a role by its name.
   * @param {string} name - e.g., 'admin', 'staff'
   * @returns {Promise<object|undefined>} The role object.
   */
  findByName: async (name) => {
    const [rows] = await db.query('SELECT * FROM roles WHERE name = ?', [name]);
    return rows[0];
  }
};

module.exports = Role;