const express = require("express");
const router = express.Router();
const { login, loginAs } = require("../controllers/authController");
const { getMe } = require("../controllers/userController");
const { auth, authorize } = require('../middleware/auth');
const checkSubscription = require('../middleware/checkSubscription');

router.post("/login", login);
router.get("/me", auth, checkSubscription, getMe);
router.post('/login-as', auth, authorize('super_admin'), loginAs);

module.exports = router;