const express = require('express');
const router = express.Router();
const dashboardController = require('../controllers/dashboardController');
const { auth, authorize } = require('../middleware/auth');
const checkSubscription = require('../middleware/checkSubscription');

const userAccess = [auth, authorize('admin', 'staff'), checkSubscription];

router.get("/stats", ...userAccess, dashboardController.getDashboardStats);
router.get("/recent-logs", ...userAccess, dashboardController.getRecentLogs);

module.exports = router;