// routes/institutionRoutes.js
const express = require('express');
const router = express.Router();
const institutionController = require('../controllers/institutionController');
const { auth, authorize } = require('../middleware/auth');
const checkSubscription = require('../middleware/checkSubscription'); // Import
const upload = require('../middleware/upload');
// --- Routes for Super Admin ---
const superAdminAccess = [auth, authorize('super_admin')];

router.post('/', ...superAdminAccess, institutionController.createInstitution);
router.get('/', ...superAdminAccess, institutionController.getAllInstitutions);
router.get('/:id', ...superAdminAccess, institutionController.getInstitutionById);
router.put('/:id', ...superAdminAccess, institutionController.updateInstitution);
router.patch('/:id/status', ...superAdminAccess, institutionController.updateInstitutionStatus);
router.put('/:id', ...superAdminAccess, upload.single('logo'), institutionController.updateInstitution);

// --- Routes for Institution Admin/Staff (MUST have subscription check) ---
const institutionUserAccess = [auth, checkSubscription]; // Simplified access array

router.get('/my-institution/details', ...institutionUserAccess, authorize('admin', 'staff'), institutionController.getMyInstitution);
router.put('/my-institution/details', ...institutionUserAccess, authorize('admin'), upload.single('logo'), institutionController.updateMyInstitutionDetails);
router.post('/my-institution/logo', ...institutionUserAccess, authorize('admin'), upload.single('logo'), institutionController.updateMyInstitutionLogo);

module.exports = router;