const express = require('express');
const router = express.Router();
const settingsController = require('../controllers/settingsController');
const { auth, authorize } = require('../middleware/auth');
const checkSubscription = require('../middleware/checkSubscription');

const adminAccess = [auth, authorize('admin'), checkSubscription];

router.get('/', ...adminAccess, settingsController.getSettings);
router.put('/', ...adminAccess, settingsController.updateSettings);

module.exports = router;