const express = require('express');
const router = express.Router();
const userController = require('../controllers/userController');
const { auth, authorize } = require('../middleware/auth');
const checkSubscription = require('../middleware/checkSubscription');

const adminAccess = [auth, authorize('admin'), checkSubscription];

router.post('/', ...adminAccess, userController.createStaffUser);
router.get('/', ...adminAccess, userController.getUsersByMyInstitution);
router.patch('/:id/status', ...adminAccess, userController.updateUserStatus);

module.exports = router;